$(document).ready(async function () {
  $("#tutorial").on("click", function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de agendamento guia.",
          position: "right",
        },
      },
      {
        element: "#btnImprimir",
        popover: {
          title: "Botão Imprimir",
          description: "Clique aqui para imprimir a consulta.",
          position: "right",
        },
      },
      {
        element: "#tabelaAgendamento",
        popover: {
          title: "Tabela Agengamento Guia",
          description: "Aqui estão os agendamentos cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });

  const permissaoUsuarioLogado = await permissaoAcessos("AGENDAMENTO_GUIA");

  await componentesPesquisa();

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>   ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnIncluir").on("click", function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "agendamento_guia/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $("#btnConsultar").on("click", async function () {
    await ConsultaAgendamento();
    $("#modal-filtros").modal("hide");
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#btnLimpaGuia").trigger("click");
    $('#txtDataDe').val('1200-01-01');
    $('#txtDataAte').val('2500-12-31');
  });

  $("#tabelaAgendamento").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaAgendamento")
        .DataTable()
        .row($(this).parents("tr"))
        .data();
      let registroLiberado = await verificarRegistro("AGENDAMENTO_GUIA", data.SENHA);
      if (registroLiberado) {
        window.location.href = `agendamento_guia/${criptografaUrl(`SENHA=${data.SENHA}&DATA=${data.DATA}`)}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaAgendamento").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaAgendamento").DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro("AGENDAMENTO_GUIA", data.CODIGO);
      if (registroLiberado) {
        window.location.href = `agendamento_guia/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });


  $('#tabelaAgendamento').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaAgendamento").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/sisplan/cadastros/v1/agendamento_guia?", `SENHA=${valorLinha.SENHA}&DATA=${valorLinha.DATA.slice(0, 10)}`);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function componentesPesquisa() {
    await componenteFiltro('vendedor', true, true, 'Guia');
  }

  async function ConsultaAgendamento() {
    $.LoadingOverlay("show");
    try {
      if ($.fn.DataTable.isDataTable('#tabelaAgendamento')) {
        $('#tabelaAgendamento').DataTable().destroy();
        $('#tabelaAgendamento').empty();
      }
      const url = '/sisplan/cadastros/v1/agendamento_guia?';
      const filtros = await retornaFiltros();
      const response = await requisicao('GET', url, filtros, null, 50000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.mensagem)
        return;
      }

      if (jsonStr.length == 0) {
        msgAlerta('Nenhum registro encontrado!');
        return;
      }

      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }

      const colunas = [
        { title: 'Senha', data: 'SENHA' },
        { title: 'Data', data: 'DATA' },
        { title: 'Guia', data: 'GUIA' },
        { title: 'Nome Guia', data: 'NOME_GUIA' },
        { title: 'Qtde Passageiro', data: 'QTDE_PASSAGEIRO' },
        { title: 'Agência', data: 'AGENCIA' },
        { title: 'Nome Agência', data: 'NOME_AGENCIA' },
        { title: 'Hora Entrada', data: 'HORA_ENTRADA' },
        { title: 'Hora Saída', data: 'HORA_SAIDA' },
        { title: 'Comissão Guia', data: 'COMISSAO_GUIA' },
        { title: 'Comissão Agência', data: 'COMISSAO_AGENCIA' },
        { title: 'Comissão Guia 2', data: 'COMISSAO_GUIA2' },
        { title: 'Comissão Agência 2', data: 'COMISSAO_AGENCIA2' }
      ];

      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.mensagem);
        return;
      }

      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      if (colunasInvisiveis == null || colunasInvisiveis.acessoCadAgendGuia == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadAgendGuia: ['EMPRESA'] }));
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      }

      $("#tabelaAgendamento").DataTable({
        destroy: true,
        lengthChange: true,
        searching: true,
        paging: true,
        scrollX: true,
        scrollY: '350px',
        serverside: true,
        autoWidth: true,
        data: jsonStr,
        columns: colunas,
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
          {
            "type": 'date-br',
            "targets": [1],
            "render": function (data) {
              if (data != undefined) {
                x = data.slice(0, 10).split('-');
                return `${x[2]}/${x[1]}/${x[0]}${data.slice(10, 19)}`;
              } else {
                return ''
              }
            }
          },
          {
            "type": 'date-br',
            "targets": [7, 8],
            "render": function (data) {
              if (data != undefined) {
                return `${data.slice(10, 19)}`;
              } else {
                return ''
              }
            }
          },
          {
            "render": function (data) {
              return parseFloat(data ?? 0).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              })
            },
            "targets": [9, 10, 11, 12],
            "className": 'pr-4 text-right'
          },
          {
            "targets": [4],
            "className": 'pr-4 text-right'
          }
        ],
      });

      $('#tabelaAgendamento_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaAgendamento_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const dados = $("#tabelaAgendamento").DataTable().data().toArray();
        await exportaCSV("", "", undefined, null, 'Relatório da aba acesso agendamento guia', '', '', 999, false, false, dados);
      });

      $('#tabelaAgendamento').DataTable().columns().every(function () {
        if ((colunasInvisiveis.acessoCadAgendGuia).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaAgendamento').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    adicionaColunas(cols, colunasInvisiveis.acessoCadAgendGuia ?? ['EMPRESA']);
  });

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      removeColunasFixas(novasColunas, ["SENHA"]);
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadAgendGuia: novasColunas }));

      $('#tabelaAgendamento').DataTable().columns().visible(true);

      $('#tabelaAgendamento').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  });

  async function retornaFiltros() {
    const dtDataDe = $('#txtDataDe').val();
    const dtDataAte = $('#txtDataAte').val();
    const guia = await formataListas($('#txtGuia').val().toString());

    const retorno = `DATA_DE=${dtDataDe}` +
      `&DATA_ATE=${dtDataAte}` +
      `&GUIA=${guia}`;

    return retorno;
  }


  $("#btnImprimir").on("click", async function () {
    $.LoadingOverlay("show");
    try {
      const filtros = await retornaFiltros();
      const url = `/sisplan/impressao/v1/acessoagendamentoguia?${filtros}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('AcessoAgendamentoGuia');
      let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'AcessoAgendamentoGuia');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  });
});
