$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description:
            "Clique aqui para ter acesso aos filtros e iniciar uma consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de uma tabela de serviços.",
          position: "right",
        },
      },
      {
        element: "#tabelaServicos",
        popover: {
          title: "Tabela de Serviços",
          description: "Aqui estão os dados das tabelas de serviços cadastradas.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  await consultaDados();
  const permissaoUsuarioLogado = await permissaoAcessos("CADTABSERVICO");

  $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"TABSERV", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnCodigo').pesquisa('#txtCodigo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABSERV", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Tabela Servicos', '');

  $('#btnLimpaCodigo').on('click', async function () {
    $('#txtCodigo').val('');
  })

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#txtCodigo').val('');
  });

  $("#btnIncluir").on("click", async function () {

    if (permissaoUsuarioLogado.INCLUI == 'S') {
      const proximo = await RetornaProximo('TABSERV', 'TABSERV', 'CODIGO', 0);

      window.location.href = `cadtabservico/${proximo}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" title="Excluir" id="btn-excluir">Excluir</button>     ' +
      '</div>';
    return retorno;
  };

  $("#btnConsultar").on("click", async function () {
    await consultaDados();
    $("#modal-filtros").modal("hide");
  });

  async function consultaDados() {
    try {
      $.LoadingOverlay("show");
      try {

        let params = '[ " 1=1 ';
        if ($('#txtCodigo').val() != '') {
          params += ` AND CODIGO = '${pegaChave('#txtCodigo')}'`;
        }
        params += ' " ]';

        let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela": "TABSERV", "camposSelect": ["CODIGO", "DESCRICAO"], "where": ${params}}`, null);
        if (!response) { return; }
        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
        if (colunasInvisiveis == null || colunasInvisiveis.acessoCadTabServicos == undefined) {
          localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadTabServicos: ['EMPRESA'] }));
          colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
        }

        if (jsonStr.RESULT[0].length > 0) {
          $("#tabelaServicos").DataTable({
            searching: true,
            destroy: true,
            lengthChange: true,
            serverSide: false,
            scrollX: true,
            scrollY: '350px',
            data: jsonStr.RESULT[0],
            "columns": [{
              "title": "Código",
              "data": "CODIGO"
            },
            {
              "title": "Descrição",
              "data": "DESCRICAO"
            }],
            columnDefs: [
              {
                targets: [0], render: function (data) {
                  return retornaBotaoOpcoes(data);
                },
              },
            ],
          });

          $('#tabelaServicos_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
          $('#tabelaServicos_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

          $('#buttonColVis').prop('title', 'Configurar colunas visíveis');
          $('#buttonExcel').prop('title', 'Exportar');

          $('#buttonColVis').on('click', async function () {
            $.LoadingOverlay('show');
            $('#modal-ColunasVisiveis').modal('show');
            $.LoadingOverlay('hide');
          });

          $('#buttonExcel').on('click', async function () {
            const dados = $("#tabelaServicos").DataTable().data().toArray();
            await exportaCSV("", "", undefined, null, 'Relatório da aba serviços acesso tabela serviços', '', '', 999, false, false, dados);
          });

          $('#tabelaServicos').DataTable().columns().every(function () {
            if ((colunasInvisiveis.acessoCadTabServicos).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          });

          $("input[type='search']").focus();
        }
      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível buscar os dados: ${error}`);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaServicos').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    adicionaColunas(cols, colunasInvisiveis.acessoCadTabServicos ?? ['EMPRESA']);
  });

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      removeColunasFixas(novasColunas, ["CODIGO"]);
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadTabServicos: novasColunas }));

      $('#tabelaServicos').DataTable().columns().visible(true);

      $('#tabelaServicos').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  });

  async function excluiLinha(codigo) {
    if (!!await buscaValor('SERVICO', 'CODSERV', 'CODSERV', codigo)) {
      throw msgAlerta('Código esta sendo utilizado no Cadastro de Serviços. Impossível Excluir.')
    }

    let response = await requisicao("DELETE", `/Sisplan/Cadastros/V1/cadtabservico?`, `CODIGO=${codigo}`, 15000);

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgAlerta(jsonStr[0].mensagem);
      return;
    }

    toastr
      .success("Exclusão realizada com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/cadtabservico`;
        },
      })
      .css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
  }

  $("#tabelaServicos").on("click", "#btn-excluir", async function () {
    msgAlerta('Deseja excluir este registro?', async () => {
      if (permissaoUsuarioLogado.EXCLUI == 'S') {
        let data = $("#tabelaServicos").DataTable().row($(this).parents("tr")).data();
        await excluiLinha(data.CODIGO);
      } else {
        msgAlertaSemConfirmacao("Sem permissão para excluir!");
      }
    })
  });

  $("#tabelaServicos").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaServicos").DataTable().row($(this).parents("tr")).data();
      let clienteLiberado = await liberarRegistro("CADTABSERVICO", data.CODIGO);
      if (clienteLiberado) {
        window.location.href = `cadtabservico/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaServicos").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaServicos").DataTable().row($(this)).data();
      let clienteLiberado = await liberarRegistro("CADTABSERVICO", data.CODIGO);
      if (clienteLiberado) {
        window.location.href = `cadtabservico/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("input[type='search']").on("keydown", function () {
    if (window.event.which === 13) {
      $("#btn-editar").trigger("click");
    }
  });
});
