$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true
        });

        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Código',
                description: 'O campo de código é preenchido automaticamente após gravar o registro.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Neste campo adicionamos a descrição para a Linha.',
                position: 'top'
            }
        },
        {
            element: '#txtOrdem',
            popover: {
                title: 'Ordem',
                description: 'Este campo, podemos adicionar um número da ordem, ou seguir com o número, que é gerado sequencialmente.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a linha.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {


    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let linha = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('LINHA', getCookie('usuario'), linha);
        window.location.href = `${BASE_URI}/linha`;
    });

    $(document).ready(function () {

        $('#txtCodigo').prop('disabled', true);

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição válida."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    try {
        let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"tablin", 
                "camposSelect":["count(CODIGO) as CONTAGEM"], 
                "where": ["1 = 1"]}`, null);
        let jsonStr = await response.json();
        $('#txtOrdem').val(jsonStr.RESULT[0][0].CONTAGEM + 1);
    } catch (error) {
        console.error(error);
    }

    if (linha != '' && linha != 'create') {

        if (await liberarRegistro('LINHA', linha) == false) {
            window.location.href = '../linha';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response1 = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"tablin", 
                    "camposSelect":["codigo", "descricao", "ordem"], 
                    "where": ["codigo = '${linha}'"]}`, null);

                    if (!response1) {
                        return;
                    }
                    let jsonStr1 = await response1.json();
                    if (response1.status != 200) {
                        msgErro(jsonStr1.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtCodigo').val(jsonStr1.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val(jsonStr1.RESULT[0][0].DESCRICAO);
                    $('#txtOrdem').val(jsonStr1.RESULT[0][0].ORDEM);

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do tamanho: ${error}`);
                }
            } finally {
                $.LoadingOverlay('hide');
            }
        }
    };

    $("#gravar").click(

        async function () {

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    let linhaClasse = {};

                    linhaClasse.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('tablin', 'tablin', 'CODIGO', 5) : $('#txtCodigo').val();
                    linhaClasse.DESCRICAO = $('#txtDescricao').val().toUpperCase();
                    linhaClasse.ORDEM = $('#txtOrdem').val();

                    let response2 = await requisicao('POST', '/Sisplan/Cadastros/v1/linha?', `JSON=${encodeURIComponent(JSON.stringify(linhaClasse))}`, null);

                    if (!response2) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr2 = await response2.json();
                    if (response2.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr2.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!
                        Linha: ${linhaClasse.CODIGO}`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/linha`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    $.LoadingOverlay("hide");
                    msgErro(`Não foi possível gravar os dados do tamanho: ${error}`);
                }
            }
        });
});